/* ----------------------------------------------------------------------------
 * This file was automatically generated by SWIG (https://www.swig.org).
 * Version 4.4.0
 *
 * Do not make changes to this file unless you know what you are doing - modify
 * the SWIG interface file instead.
 * ----------------------------------------------------------------------------- */

package org.itk.simple;
/**

Paste an image (or a constant value) into another image.


PasteImageFilter allows a region in a destination image to be filled with a source
image or a constant pixel value. The SetDestinationIndex() method prescribes where in the destination input to start pasting
data from the source input. The SetSourceRegion method prescribes the
section of the second image to paste into the first. When a constant
pixel value is set, the SourceRegion describes the size of the region
filled. If the output requested region does not include the
SourceRegion after it has been repositioned to DestinationIndex, then
the output will just be a copy of the input.

This filter supports running "InPlace" to efficiently reuses the
destination image buffer for the output, removing the need to copy the
destination pixels to the output.

When the source image is a lower dimension than the destination image
then the DestinationSkipAxes parameter specifies which axes in the
destination image are set to 1 when copying the region or filling with
a constant.

C++ includes: sitkPasteImageFilter.h
*/
public class PasteImageFilter extends ImageFilter {
  private transient long swigCPtr;

  protected PasteImageFilter(long cPtr, boolean cMemoryOwn) {
    super(SimpleITKJNI.PasteImageFilter_SWIGUpcast(cPtr), cMemoryOwn);
    swigCPtr = cPtr;
  }

  protected static long getCPtr(PasteImageFilter obj) {
    return (obj == null) ? 0 : obj.swigCPtr;
  }

  protected static long swigRelease(PasteImageFilter obj) {
    long ptr = 0;
    if (obj != null) {
      if (!obj.swigCMemOwn)
        throw new RuntimeException("Cannot release ownership as memory is not owned");
      ptr = obj.swigCPtr;
      obj.swigCMemOwn = false;
      obj.delete();
    }
    return ptr;
  }

  @SuppressWarnings({"deprecation", "removal"})
  protected void finalize() {
    delete();
  }

  /**
virtual itk::simple::PasteImageFilter::~PasteImageFilter()

Destructor

*/
public  void delete() {
    if (swigCPtr != 0) {
      if (swigCMemOwn) {
        swigCMemOwn = false;
        SimpleITKJNI.delete_PasteImageFilter(swigCPtr);
      }
      swigCPtr = 0;
    }
    super.delete();
  }

  /**
itk::simple::PasteImageFilter::PasteImageFilter()

Default Constructor that takes no arguments and initializes default
parameters

*/
public  PasteImageFilter() {
    this(SimpleITKJNI.new_PasteImageFilter(), true);
  }

  /**
Self&amp; itk::simple::PasteImageFilter::SetSourceSize(std::vector&lt; unsigned int &gt; SourceSize)
*/
public  void setSourceSize(VectorUInt32 SourceSize) {
    SimpleITKJNI.PasteImageFilter_setSourceSize(swigCPtr, this, VectorUInt32.getCPtr(SourceSize), SourceSize);
  }

  /**
std::vector&lt;unsigned int&gt; itk::simple::PasteImageFilter::GetSourceSize() const
*/
public  VectorUInt32 getSourceSize() {
    return new VectorUInt32(SimpleITKJNI.PasteImageFilter_getSourceSize(swigCPtr, this), true);
  }

  /**
Self&amp; itk::simple::PasteImageFilter::SetSourceIndex(std::vector&lt; int &gt; SourceIndex)
*/
public  void setSourceIndex(VectorInt32 SourceIndex) {
    SimpleITKJNI.PasteImageFilter_setSourceIndex(swigCPtr, this, VectorInt32.getCPtr(SourceIndex), SourceIndex);
  }

  /**
std::vector&lt;int&gt; itk::simple::PasteImageFilter::GetSourceIndex() const
*/
public  VectorInt32 getSourceIndex() {
    return new VectorInt32(SimpleITKJNI.PasteImageFilter_getSourceIndex(swigCPtr, this), true);
  }

  /**
Self&amp; itk::simple::PasteImageFilter::SetDestinationIndex(std::vector&lt; int &gt; DestinationIndex)

Set/Get the destination index (where in the first input the second
input will be pasted.

*/
public  void setDestinationIndex(VectorInt32 DestinationIndex) {
    SimpleITKJNI.PasteImageFilter_setDestinationIndex(swigCPtr, this, VectorInt32.getCPtr(DestinationIndex), DestinationIndex);
  }

  /**
std::vector&lt;int&gt; itk::simple::PasteImageFilter::GetDestinationIndex() const

Set/Get the destination index (where in the first input the second
input will be pasted.

*/
public  VectorInt32 getDestinationIndex() {
    return new VectorInt32(SimpleITKJNI.PasteImageFilter_getDestinationIndex(swigCPtr, this), true);
  }

  /**
Self&amp; itk::simple::PasteImageFilter::SetDestinationSkipAxes(std::vector&lt; bool &gt; DestinationSkipAxes)

Set/Get the array describing which axes in the destination image to
skip

The axes with true values are set to 1, to fill the difference between
the dimension of the input and source image. The number of true value
in DestinationSkipAxes plus the DestinationImageDimension must equal
the InputImageDimension.

By default this array contains SourceImageDimension false values
followed by true values for the remainder.

*/
public  void setDestinationSkipAxes(VectorBool DestinationSkipAxes) {
    SimpleITKJNI.PasteImageFilter_setDestinationSkipAxes(swigCPtr, this, VectorBool.getCPtr(DestinationSkipAxes), DestinationSkipAxes);
  }

  /**
std::vector&lt;bool&gt; itk::simple::PasteImageFilter::GetDestinationSkipAxes() const

Set/Get the array describing which axes in the destination image to
skip

The axes with true values are set to 1, to fill the difference between
the dimension of the input and source image. The number of true values
in DestinationSkipAxes plus the DestinationImageDimension must equal
the InputImageDimension.

By default this array contains SourceImageDimension false values
followed by true values for the remainder.

*/
public  VectorBool getDestinationSkipAxes() {
    return new VectorBool(SimpleITKJNI.PasteImageFilter_getDestinationSkipAxes(swigCPtr, this), true);
  }

  /**
std::string itk::simple::PasteImageFilter::GetName() const

Name of this class

*/
public  String getName() {
    return SimpleITKJNI.PasteImageFilter_getName(swigCPtr, this);
  }

  /**
std::string itk::simple::PasteImageFilter::ToString() const

Print ourselves out

*/
public  String toString() {
    return SimpleITKJNI.PasteImageFilter_toString(swigCPtr, this);
  }

  /**
Image itk::simple::PasteImageFilter::Execute(Image &amp;&amp;destinationImage, double constant)
*/
public  Image execute(Image destinationImage, Image sourceImage) {
    return new Image(SimpleITKJNI.PasteImageFilter_execute__SWIG_0(swigCPtr, this, Image.getCPtr(destinationImage), destinationImage, Image.getCPtr(sourceImage), sourceImage), true);
  }

  /**
Image itk::simple::PasteImageFilter::Execute(Image &amp;&amp;destinationImage, double constant)
*/
public  Image execute(Image destinationImage, double constant) {
    return new Image(SimpleITKJNI.PasteImageFilter_execute__SWIG_1(swigCPtr, this, Image.getCPtr(destinationImage), destinationImage, constant), true);
  }

}
