/*
 * Decompiled with CFR 0.152.
 */
package ghidra.framework.plugintool.mgr;

import ghidra.framework.model.ToolListener;
import ghidra.framework.plugintool.PluginEvent;
import ghidra.framework.plugintool.PluginTool;
import ghidra.framework.plugintool.mgr.Counter;
import ghidra.framework.plugintool.util.PluginEventListener;
import ghidra.util.Msg;
import ghidra.util.Swing;
import java.awt.Component;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.LinkedHashMap;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.apache.commons.collections4.IterableUtils;
import org.apache.commons.collections4.map.LazyMap;

public class EventManager {
    private List<ToolListener> toolListeners = new ArrayList<ToolListener>();
    private Map<Class<? extends PluginEvent>, Set<PluginEventListener>> listenersByEventType = LazyMap.lazyMap(new HashMap(), clazz -> new HashSet());
    private Map<String, Counter> producerMap = LazyMap.lazyMap(new HashMap(), name -> new Counter());
    private Map<String, Counter> consumerMap = LazyMap.lazyMap(new HashMap(), name -> new Counter());
    private LinkedHashMap<Class<? extends PluginEvent>, PluginEvent> lastEventsByType = new LinkedHashMap();
    private LinkedList<PluginEvent> eventQ = new LinkedList();
    private Set<PluginEventListener> allEventListeners = new HashSet<PluginEventListener>();
    private PluginTool tool;
    private PluginEvent currentEvent;
    private final Runnable sendEventsRunnable = () -> this.sendEvents();
    private volatile boolean sendingToolEvent;

    public EventManager(PluginTool tool) {
        this.tool = tool;
    }

    public void addEventListener(Class<? extends PluginEvent> eventClass, PluginEventListener listener) {
        String name;
        Set<PluginEventListener> set = this.listenersByEventType.get(eventClass);
        if (set.isEmpty() && (name = PluginEvent.lookupToolEventName(eventClass)) != null) {
            ++this.consumerMap.get((Object)name).count;
        }
        set.add(listener);
    }

    public void addAllEventListener(PluginEventListener listener) {
        this.allEventListeners.add(listener);
    }

    public void removeAllEventListener(PluginEventListener listener) {
        this.allEventListeners.remove(listener);
    }

    public void removeEventListener(Class<? extends PluginEvent> eventClass, PluginEventListener listener) {
        Set<PluginEventListener> set = this.listenersByEventType.get(eventClass);
        set.remove(listener);
        if (set.isEmpty()) {
            this.eventConsumerRemoved(eventClass);
        }
    }

    private void eventConsumerRemoved(Class<? extends PluginEvent> eventClass) {
        String name = PluginEvent.lookupToolEventName(eventClass);
        if (name == null) {
            return;
        }
        Counter counter = this.consumerMap.get(name);
        if (--counter.count == 0) {
            this.consumerMap.remove(name);
        }
    }

    public void addToolListener(ToolListener listener) {
        this.toolListeners.add(listener);
    }

    public void removeToolListener(ToolListener listener) {
        this.toolListeners.remove(listener);
    }

    public boolean hasToolListeners() {
        return !this.toolListeners.isEmpty();
    }

    public void addEventProducer(Class<? extends PluginEvent> eventClass) {
        String name = PluginEvent.lookupToolEventName(eventClass);
        if (name != null) {
            Counter counter = this.producerMap.get(name);
            ++counter.count;
        }
    }

    public void removeEventProducer(Class<? extends PluginEvent> eventClass) {
        String name = PluginEvent.lookupToolEventName(eventClass);
        if (name == null) {
            return;
        }
        Counter counter = this.producerMap.get(name);
        if (--counter.count == 0) {
            this.producerMap.remove(name);
        }
    }

    public String[] getEventsProduced() {
        return this.producerMap.keySet().toArray(new String[this.producerMap.size()]);
    }

    public String[] getEventsConsumed() {
        return this.consumerMap.keySet().toArray(new String[this.consumerMap.size()]);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void fireEvent(PluginEvent event) {
        LinkedList<PluginEvent> linkedList = this.eventQ;
        synchronized (linkedList) {
            if (this.currentEvent != null) {
                if (this.validateEventChain(this.currentEvent, event)) {
                    event.setTriggerEvent(this.currentEvent);
                    this.eventQ.add(event);
                }
                return;
            }
        }
        this.eventQ.add(event);
        Swing.runNow((Runnable)this.sendEventsRunnable);
    }

    private boolean validateEventChain(PluginEvent startEvent, PluginEvent newEvent) {
        while (startEvent != null) {
            if (startEvent.getClass().isAssignableFrom(newEvent.getClass()) && startEvent.getEventName().equals(newEvent.getEventName())) {
                return false;
            }
            startEvent = startEvent.getTriggerEvent();
        }
        return true;
    }

    public void processToolEvent(PluginEvent event) {
        if (!this.sendingToolEvent) {
            this.fireEvent(event);
        }
    }

    public void clearLastEvents() {
        this.lastEventsByType.clear();
    }

    public void clear() {
        this.allEventListeners.clear();
        this.toolListeners.clear();
        this.currentEvent = null;
        this.lastEventsByType.clear();
        this.listenersByEventType.clear();
        this.eventQ.clear();
    }

    public PluginEvent[] getLastEvents() {
        return this.lastEventsByType.values().toArray(new PluginEvent[this.lastEventsByType.size()]);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void sendEvents() {
        Swing.assertSwingThread((String)"Events must be sent on the Swing thread");
        LinkedList<PluginEvent> linkedList = this.eventQ;
        synchronized (linkedList) {
            this.currentEvent = this.eventQ.poll();
        }
        while (this.currentEvent != null) {
            Class<?> eventClass = this.currentEvent.getClass();
            this.lastEventsByType.put(eventClass, this.currentEvent);
            for (PluginEventListener listener : this.getListeners(eventClass)) {
                try {
                    listener.eventSent(this.currentEvent);
                }
                catch (Throwable t) {
                    Msg.showError((Object)this, (Component)this.tool.getToolFrame(), (String)"Plugin Event Error", (Object)"Error in plugin event listener", (Throwable)t);
                }
            }
            this.sendToolEvent(this.currentEvent);
            LinkedList<PluginEvent> linkedList2 = this.eventQ;
            synchronized (linkedList2) {
                this.currentEvent = this.eventQ.poll();
            }
        }
        this.tool.contextChanged(null);
    }

    private Iterable<PluginEventListener> getListeners(Class<? extends PluginEvent> eventClass) {
        Set<PluginEventListener> specificListeners = this.listenersByEventType.get(eventClass);
        return IterableUtils.chainedIterable(specificListeners, this.allEventListeners);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void sendToolEvent(PluginEvent event) {
        if (this.toolListeners.isEmpty()) {
            return;
        }
        if (!event.isToolEvent()) {
            return;
        }
        this.sendingToolEvent = true;
        try {
            event.setSourceName("External Tool");
            event.setTriggerEvent(null);
            for (int i = 0; i < this.toolListeners.size(); ++i) {
                ToolListener tl = this.toolListeners.get(i);
                try {
                    tl.processToolEvent(event);
                    continue;
                }
                catch (Throwable t) {
                    Msg.showError((Object)this, (Component)this.tool.getToolFrame(), (String)"Plugin Event Error", (Object)"Error sending event to connected tool", (Throwable)t);
                }
            }
        }
        finally {
            this.sendingToolEvent = false;
        }
    }

    public void removeEventListener(String className) {
        ArrayList<Class<? extends PluginEvent>> unusedList = new ArrayList<Class<? extends PluginEvent>>();
        block0: for (Class<? extends PluginEvent> eventClass : this.listenersByEventType.keySet()) {
            Set<PluginEventListener> set = this.listenersByEventType.get(eventClass);
            Iterator<PluginEventListener> it = set.iterator();
            while (it.hasNext()) {
                PluginEventListener listener = it.next();
                if (!listener.getClass().getName().equals(className)) continue;
                it.remove();
                if (!set.isEmpty()) continue block0;
                unusedList.add(eventClass);
                continue block0;
            }
        }
        for (int i = 0; i < unusedList.size(); ++i) {
            Class eventClass = (Class)unusedList.get(i);
            this.eventConsumerRemoved(eventClass);
        }
    }
}

