/*
 * Decompiled with CFR 0.152.
 */
package ghidra.framework.main.projectdata.actions;

import docking.action.MenuData;
import docking.widgets.tree.GTree;
import docking.widgets.tree.GTreeNode;
import docking.widgets.tree.tasks.GTreeExpandAllTask;
import ghidra.framework.main.datatable.ProjectTreeAction;
import ghidra.framework.main.datatree.DataTree;
import ghidra.framework.main.datatree.FrontEndProjectTreeContext;
import java.util.ArrayList;
import java.util.List;
import javax.swing.tree.TreePath;

public class ProjectDataSelectAction
extends ProjectTreeAction {
    public ProjectDataSelectAction(String owner, String group) {
        super("Select All", owner);
        this.setPopupMenuData(new MenuData(new String[]{"Select Children"}, group));
        this.markHelpUnnecessary();
    }

    @Override
    protected void actionPerformed(FrontEndProjectTreeContext context) {
        DataTree tree = context.getTree();
        TreePath[] paths = context.getSelectionPaths();
        GTreeNode node = (GTreeNode)paths[0].getLastPathComponent();
        this.selectAllChildren(tree, node);
    }

    @Override
    public boolean isAddToPopup(FrontEndProjectTreeContext context) {
        return context.getFolderCount() == 1 && context.getFileCount() == 0;
    }

    private void selectAllChildren(DataTree tree, GTreeNode node) {
        ArrayList paths = new ArrayList();
        tree.runTask(monitor -> {
            GTreeExpandAllTask task = new GTreeExpandAllTask((GTree)tree, node);
            task.run(monitor);
            this.getAllTreePaths(node, paths);
            tree.setSelectionPaths(paths);
        });
    }

    private void getAllTreePaths(GTreeNode node, List<TreePath> paths) {
        paths.add(node.getTreePath());
        List children = node.getChildren();
        for (GTreeNode child : children) {
            this.getAllTreePaths(child, paths);
        }
    }
}

