/*
 * Decompiled with CFR 0.152.
 */
package ghidra.app.util.bin.format.pdb2.pdbreader.symbol;

import ghidra.app.util.bin.format.pdb2.pdbreader.AbstractPdb;
import ghidra.app.util.bin.format.pdb2.pdbreader.PdbByteReader;
import ghidra.app.util.bin.format.pdb2.pdbreader.PdbException;
import ghidra.app.util.bin.format.pdb2.pdbreader.symbol.AbstractMsSymbol;
import ghidra.app.util.bin.format.pdb2.pdbreader.symbol.AddressGap;
import ghidra.app.util.bin.format.pdb2.pdbreader.symbol.AddressRange;
import java.util.ArrayList;
import java.util.List;

public abstract class AbstractDefinedSingleAddressRangeMsSymbol
extends AbstractMsSymbol {
    protected AddressRange addressRange;
    protected List<AddressGap> addressGapList = new ArrayList<AddressGap>();

    public AbstractDefinedSingleAddressRangeMsSymbol(AbstractPdb pdb, PdbByteReader reader) throws PdbException {
        super(pdb, reader);
    }

    public AddressRange getAddressRange() {
        return this.addressRange;
    }

    public List<AddressGap> getAddressGapList() {
        return this.addressGapList;
    }

    protected void parseRangeAndGaps(PdbByteReader reader) throws PdbException {
        this.addressRange = new AddressRange(reader);
        while (reader.hasMore()) {
            AddressGap gap = new AddressGap(reader);
            this.addressGapList.add(gap);
        }
    }

    protected void emitRangeAndGaps(StringBuilder builder) {
        builder.append(this.addressRange);
        builder.append(String.format(", %d Gaps", this.addressGapList.size()));
        if (this.addressGapList.isEmpty()) {
            return;
        }
        builder.append(" (startOffset, length):");
        for (AddressGap gap : this.addressGapList) {
            builder.append(gap);
        }
    }
}

