/*
 * Decompiled with CFR 0.152.
 */
package ghidra.trace.database.target;

import ghidra.program.model.address.Address;
import ghidra.program.model.address.AddressRange;
import ghidra.trace.database.space.DBTraceSpaceKey;
import ghidra.trace.database.target.DBTraceObject;
import ghidra.trace.model.Lifespan;
import ghidra.trace.model.TraceUniqueObject;
import ghidra.trace.model.target.TraceObject;
import ghidra.trace.model.target.TraceObjectValue;
import ghidra.trace.model.target.iface.TraceObjectInterface;
import ghidra.trace.model.target.schema.TraceObjectSchema;
import ghidra.trace.util.TraceAddressSpace;
import ghidra.trace.util.TraceChangeRecord;
import ghidra.trace.util.TraceEvent;
import ghidra.trace.util.TraceEvents;
import ghidra.util.database.ObjectKey;

public interface DBTraceObjectInterface
extends TraceObjectInterface,
TraceUniqueObject {
    public TraceChangeRecord<?, ?> translateEvent(TraceChangeRecord<?, ?> var1);

    public static TraceAddressSpace spaceForValue(TraceObject object, long snap, String key) {
        TraceObjectValue val = object.getAttribute(snap, key);
        if (val == null) {
            return null;
        }
        Object object2 = val.getValue();
        if (object2 instanceof Address) {
            Address address = (Address)object2;
            return new DBTraceSpaceKey.DefaultDBTraceSpaceKey(null, address.getAddressSpace(), 0);
        }
        object2 = val.getValue();
        if (object2 instanceof AddressRange) {
            AddressRange range = (AddressRange)object2;
            return new DBTraceSpaceKey.DefaultDBTraceSpaceKey(null, range.getAddressSpace(), 0);
        }
        return null;
    }

    default public TraceAddressSpace spaceForValue(long snap, String key) {
        return DBTraceObjectInterface.spaceForValue(this.getObject(), snap, key);
    }

    @Override
    default public ObjectKey getObjectKey() {
        return this.getObject().getObjectKey();
    }

    @Override
    default public boolean isDeleted() {
        return this.getObject().getLife().isEmpty();
    }

    public static abstract class Translator<T> {
        private final String spaceValueKey;
        private final DBTraceObject object;
        private final T iface;
        private Lifespan.LifeSet life = new Lifespan.DefaultLifeSet();

        public Translator(String spaceValueKey, DBTraceObject object, T iface) {
            if (spaceValueKey == null) {
                this.spaceValueKey = null;
            } else {
                TraceObjectSchema schema = object.getSchema();
                this.spaceValueKey = schema.checkAliasedAttribute(spaceValueKey);
            }
            this.object = object;
            this.iface = iface;
        }

        protected abstract TraceEvent<T, Void> getAddedType();

        protected abstract TraceEvent<T, Lifespan> getLifespanChangedType();

        protected abstract TraceEvent<T, ?> getChangedType();

        protected abstract boolean appliesToKey(String var1);

        protected abstract TraceEvent<T, Void> getDeletedType();

        protected void emitExtraAdded() {
        }

        protected void emitExtraLifespanChanged(Lifespan oldLifespan, Lifespan newLifespan) {
        }

        protected void emitExtraValueChanged(Lifespan lifespan, String key, Object oldValue, Object newValue) {
        }

        protected void emitExtraDeleted() {
        }

        protected TraceAddressSpace getSpace(Lifespan.LifeSet life) {
            if (life.isEmpty()) {
                return null;
            }
            return this.spaceValueKey == null ? null : DBTraceObjectInterface.spaceForValue(this.object, ((Lifespan)life.bound()).lmin(), this.spaceValueKey);
        }

        protected TraceChangeRecord<?, ?> translateAdded() {
            TraceEvent<T, Void> type = this.getAddedType();
            if (type == null) {
                return null;
            }
            this.emitExtraAdded();
            return new TraceChangeRecord<T, Object>(type, this.getSpace(this.life), this.iface, null, null);
        }

        protected TraceChangeRecord<?, ?> translateLifespanChanged(Lifespan.LifeSet oldLife) {
            TraceEvent<T, Lifespan> type = this.getLifespanChangedType();
            if (type == null) {
                return null;
            }
            Lifespan oldLifespan = (Lifespan)oldLife.bound();
            Lifespan newLifespan = (Lifespan)this.life.bound();
            this.emitExtraLifespanChanged(oldLifespan, newLifespan);
            return new TraceChangeRecord<T, Lifespan>(type, this.getSpace(this.life), this.iface, oldLifespan, newLifespan);
        }

        protected TraceChangeRecord<?, ?> translateDeleted(Lifespan.LifeSet life) {
            TraceEvent<T, Void> type = this.getDeletedType();
            if (type == null) {
                return null;
            }
            this.emitExtraDeleted();
            return new TraceChangeRecord<T, Object>(type, this.getSpace(life), this.iface, null, null);
        }

        public TraceChangeRecord<?, ?> translate(TraceChangeRecord<?, ?> rec) {
            if (rec.getEventType() == TraceEvents.OBJECT_LIFE_CHANGED) {
                boolean newHasLife;
                if (this.object.isDeleted()) {
                    return null;
                }
                assert (rec.getAffectedObject() == this.object);
                Lifespan.LifeSet oldLife = this.life;
                this.life = this.object.getLife();
                boolean oldHasLife = !oldLife.isEmpty();
                boolean bl = newHasLife = !this.life.isEmpty();
                if (newHasLife && oldHasLife) {
                    return this.translateLifespanChanged(oldLife);
                }
                if (newHasLife) {
                    return this.translateAdded();
                }
                if (oldHasLife) {
                    return this.translateDeleted(oldLife);
                }
                throw new AssertionError((Object)"Life changed from empty to empty?");
            }
            if (rec.getEventType() == TraceEvents.VALUE_CREATED) {
                if (this.object.isDeleted()) {
                    return null;
                }
                TraceEvent<T, ?> type = this.getChangedType();
                if (type == null) {
                    return null;
                }
                TraceChangeRecord cast = TraceEvents.VALUE_CREATED.cast(rec);
                TraceObjectValue affected = (TraceObjectValue)cast.getAffectedObject();
                String key = affected.getEntryKey();
                if (!this.appliesToKey(key)) {
                    return null;
                }
                assert (affected.getParent() == this.object);
                if (this.object.getCanonicalParent(affected.getMaxSnap()) == null) {
                    return null;
                }
                this.emitExtraValueChanged(affected.getLifespan(), key, cast.getOldValue(), cast.getNewValue());
                return new TraceChangeRecord<T, Object>(type, this.getSpace(this.life), this.iface, null, null);
            }
            if (rec.getEventType() == TraceEvents.OBJECT_DELETED) {
                return this.translateDeleted(this.life);
            }
            return null;
        }
    }
}

