/*
 * Decompiled with CFR 0.152.
 */
package org.jkiss.dbeaver.ext.snowflake.model.auth;

import java.util.Properties;
import org.jkiss.code.NotNull;
import org.jkiss.dbeaver.DBException;
import org.jkiss.dbeaver.ext.snowflake.model.auth.AuthModelSnowflakeCredentials;
import org.jkiss.dbeaver.model.DBPDataSource;
import org.jkiss.dbeaver.model.DBPDataSourceContainer;
import org.jkiss.dbeaver.model.connection.DBPConnectionConfiguration;
import org.jkiss.dbeaver.model.impl.auth.AuthModelDatabaseNative;
import org.jkiss.dbeaver.model.impl.auth.AuthModelDatabaseNativeCredentials;
import org.jkiss.dbeaver.model.runtime.DBRProgressMonitor;
import org.jkiss.utils.CommonUtils;

public class SnowflakeAuthModelSnowflake<CREDENTIALS extends AuthModelSnowflakeCredentials>
extends AuthModelDatabaseNative<CREDENTIALS> {
    public static final String ID = "snowflake_snowflake";

    @NotNull
    public CREDENTIALS createCredentials() {
        return (CREDENTIALS)((Object)new AuthModelSnowflakeCredentials());
    }

    public Object initAuthentication(@NotNull DBRProgressMonitor monitor, @NotNull DBPDataSource dataSource, @NotNull CREDENTIALS credentials, @NotNull DBPConnectionConfiguration configuration, @NotNull Properties connProperties) throws DBException {
        String roleName;
        String authenticator;
        if (connProperties.getProperty("authenticator") == null && !CommonUtils.isEmpty((String)(authenticator = this.getAuthenticator(dataSource, (AuthModelDatabaseNativeCredentials)credentials, configuration)))) {
            connProperties.put("authenticator", authenticator);
        }
        if (!CommonUtils.isEmpty((String)(roleName = configuration.getAuthProperty("role")))) {
            connProperties.put("role", roleName);
        }
        return super.initAuthentication(monitor, dataSource, credentials, configuration, connProperties);
    }

    @NotNull
    public CREDENTIALS loadCredentials(@NotNull DBPDataSourceContainer dataSource, @NotNull DBPConnectionConfiguration configuration) {
        AuthModelSnowflakeCredentials credentials = (AuthModelSnowflakeCredentials)super.loadCredentials(dataSource, configuration);
        credentials.setRole(configuration.getAuthProperty("role"));
        return (CREDENTIALS)((Object)credentials);
    }

    public void saveCredentials(@NotNull DBPDataSourceContainer dataSource, @NotNull DBPConnectionConfiguration configuration, @NotNull CREDENTIALS credentials) {
        configuration.setAuthProperty("role", ((AuthModelSnowflakeCredentials)((Object)credentials)).getRole());
        super.saveCredentials(dataSource, configuration, credentials);
    }

    public void endAuthentication(@NotNull DBPDataSourceContainer dataSource, @NotNull DBPConnectionConfiguration configuration, @NotNull Properties connProperties) {
        super.endAuthentication(dataSource, configuration, connProperties);
    }

    protected String getAuthenticator(DBPDataSource dataSource, AuthModelDatabaseNativeCredentials credentials, DBPConnectionConfiguration configuration) {
        return configuration.getAuthProperty("authenticator");
    }
}

