/*
 * Decompiled with CFR 0.152.
 */
package org.jkiss.dbeaver.ui.editors.sql.convert.impl;

import java.util.Map;
import org.jkiss.dbeaver.ui.editors.sql.convert.impl.SourceCodeSQLConverter;
import org.jkiss.utils.CommonUtils;

public class DelphiSQLConverter
extends SourceCodeSQLConverter {
    public static final String OPTION_USE_STRING_BUILDER = "use-string-builder";

    @Override
    protected void convertSourceLines(StringBuilder result, String[] sourceLines, String lineDelimiter, Map<String, Object> options) {
        boolean useStringBuilder = CommonUtils.toBoolean((Object)options.get(OPTION_USE_STRING_BUILDER));
        boolean trailingLineFeed = lineDelimiter.startsWith("#");
        if (useStringBuilder) {
            result.append("Query := TStringList.Create;\n");
        }
        int i = 0;
        while (i < sourceLines.length) {
            if (useStringBuilder) {
                result.append("Query.Add(");
            }
            String line = sourceLines[i];
            line = line.replace("'", "''");
            result.append('\'').append(CommonUtils.escapeJavaString((String)line));
            if (!trailingLineFeed) {
                result.append(lineDelimiter);
            }
            result.append('\'');
            if (trailingLineFeed) {
                result.append(lineDelimiter);
            }
            if (i < sourceLines.length - 1 && !useStringBuilder) {
                result.append(" + \n");
            } else if (useStringBuilder) {
                result.append(");\n");
            }
            ++i;
        }
    }
}

