/*
 * Decompiled with CFR 0.152.
 */
package org.opensaml.saml.common.profile.logic;

import java.util.Collection;
import java.util.Set;
import java.util.function.Predicate;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import net.shibboleth.shared.annotation.ParameterName;
import net.shibboleth.shared.annotation.constraint.NotLive;
import net.shibboleth.shared.annotation.constraint.Unmodifiable;
import net.shibboleth.shared.collection.CollectionSupport;
import net.shibboleth.shared.primitive.StringSupport;
import org.opensaml.saml.saml2.metadata.EntityDescriptor;

public class EntityIdPredicate
implements Predicate<EntityDescriptor> {
    @Nonnull
    private final Set<String> entityIds;

    public EntityIdPredicate(@Nullable @ParameterName(name="ids") Collection<String> ids) {
        this.entityIds = CollectionSupport.copyToSet(StringSupport.normalizeStringCollection(ids));
    }

    @Nonnull
    @Unmodifiable
    @NotLive
    public Set<String> getEntityIds() {
        return this.entityIds;
    }

    @Override
    public boolean test(@Nullable EntityDescriptor input) {
        if (input == null || input.getEntityID() == null) {
            return false;
        }
        return this.entityIds.contains(input.getEntityID());
    }
}

