/*
 * Decompiled with CFR 0.152.
 */
package org.opensearch.core.tasks.resourcetracker;

import java.io.IOException;
import java.util.Objects;
import org.opensearch.common.annotation.PublicApi;
import org.opensearch.core.ParseField;
import org.opensearch.core.common.Strings;
import org.opensearch.core.common.io.stream.StreamInput;
import org.opensearch.core.common.io.stream.StreamOutput;
import org.opensearch.core.common.io.stream.Writeable;
import org.opensearch.core.xcontent.ConstructingObjectParser;
import org.opensearch.core.xcontent.MediaTypeRegistry;
import org.opensearch.core.xcontent.ToXContent;
import org.opensearch.core.xcontent.ToXContentFragment;
import org.opensearch.core.xcontent.XContentBuilder;
import org.opensearch.core.xcontent.XContentParser;

@PublicApi(since="2.1.0")
public class TaskResourceUsage
implements Writeable,
ToXContentFragment {
    private static final ParseField CPU_TIME_IN_NANOS = new ParseField("cpu_time_in_nanos", new String[0]);
    private static final ParseField MEMORY_IN_BYTES = new ParseField("memory_in_bytes", new String[0]);
    private final long cpuTimeInNanos;
    private final long memoryInBytes;
    public static final ConstructingObjectParser<TaskResourceUsage, Void> PARSER = new ConstructingObjectParser("task_resource_usage", a -> new TaskResourceUsage((Long)a[0], (Long)a[1]));

    public TaskResourceUsage(long cpuTimeInNanos, long memoryInBytes) {
        this.cpuTimeInNanos = cpuTimeInNanos;
        this.memoryInBytes = memoryInBytes;
    }

    public static TaskResourceUsage readFromStream(StreamInput in) throws IOException {
        return new TaskResourceUsage(in.readVLong(), in.readVLong());
    }

    @Override
    public void writeTo(StreamOutput out) throws IOException {
        out.writeVLong(this.cpuTimeInNanos);
        out.writeVLong(this.memoryInBytes);
    }

    public long getCpuTimeInNanos() {
        return this.cpuTimeInNanos;
    }

    public long getMemoryInBytes() {
        return this.memoryInBytes;
    }

    @Override
    public XContentBuilder toXContent(XContentBuilder builder, ToXContent.Params params) throws IOException {
        builder.field(CPU_TIME_IN_NANOS.getPreferredName(), this.cpuTimeInNanos);
        builder.field(MEMORY_IN_BYTES.getPreferredName(), this.memoryInBytes);
        return builder;
    }

    public static TaskResourceUsage fromXContent(XContentParser parser) {
        return PARSER.apply(parser, null);
    }

    public String toString() {
        return Strings.toString(MediaTypeRegistry.JSON, this, true, true);
    }

    public boolean equals(Object obj) {
        if (obj == null || obj.getClass() != TaskResourceUsage.class) {
            return false;
        }
        TaskResourceUsage other = (TaskResourceUsage)obj;
        return Objects.equals(this.cpuTimeInNanos, other.cpuTimeInNanos) && Objects.equals(this.memoryInBytes, other.memoryInBytes);
    }

    public int hashCode() {
        return Objects.hash(this.cpuTimeInNanos, this.memoryInBytes);
    }

    static {
        PARSER.declareLong(ConstructingObjectParser.constructorArg(), CPU_TIME_IN_NANOS);
        PARSER.declareLong(ConstructingObjectParser.constructorArg(), MEMORY_IN_BYTES);
    }
}

