/*
 * Decompiled with CFR 0.152.
 */
package com.sun.star.lib.uno.adapter;

import com.sun.star.io.IOException;
import com.sun.star.io.XInputStream;
import java.io.InputStream;

public final class InputStreamToXInputStreamAdapter
implements XInputStream {
    private final InputStream iIn;

    public InputStreamToXInputStreamAdapter(InputStream inputStream) {
        this.iIn = inputStream;
    }

    @Override
    public int available() throws IOException {
        int n;
        try {
            n = this.iIn.available();
        }
        catch (java.io.IOException iOException) {
            throw new IOException(iOException);
        }
        return n;
    }

    @Override
    public void closeInput() throws IOException {
        try {
            this.iIn.close();
        }
        catch (java.io.IOException iOException) {
            throw new IOException(iOException);
        }
    }

    @Override
    public int readBytes(byte[][] byArray, int n) throws IOException {
        try {
            long l;
            int n2 = 0;
            if (byArray[0] == null || byArray[0].length < n) {
                byArray[0] = new byte[n];
            }
            while (n > 0 && (l = (long)this.iIn.read(byArray[0], n2, n)) > 0L) {
                n2 += (int)l;
                n -= (int)l;
            }
            if (n2 < byArray[0].length) {
                byte[] byArray2 = new byte[n2];
                System.arraycopy(byArray[0], 0, byArray2, 0, n2);
                byArray[0] = byArray2;
            }
            return n2;
        }
        catch (java.io.IOException iOException) {
            throw new IOException("reader error", (Object)iOException);
        }
    }

    @Override
    public int readSomeBytes(byte[][] byArray, int n) throws IOException {
        try {
            long l;
            if (byArray[0] == null || byArray[0].length < n) {
                byArray[0] = new byte[n];
            }
            if ((l = n > this.iIn.available() ? (long)this.iIn.read(byArray[0], 0, this.iIn.available()) : (long)this.iIn.read(byArray[0], 0, n)) < (long)byArray[0].length) {
                int n2 = l > 0L ? (int)l : 0;
                byte[] byArray2 = new byte[n2];
                System.arraycopy(byArray[0], 0, byArray2, 0, n2);
                byArray[0] = byArray2;
            }
            if (l <= 0L) {
                return 0;
            }
            return (int)l;
        }
        catch (java.io.IOException iOException) {
            throw new IOException("reader error", (Object)iOException);
        }
    }

    @Override
    public void skipBytes(int n) throws IOException {
        try {
            this.iIn.available();
        }
        catch (java.io.IOException iOException) {
            throw new IOException(iOException);
        }
        do {
            try {
                n = (int)((long)n - this.iIn.skip(n));
            }
            catch (java.io.IOException iOException) {
                throw new IOException(iOException);
            }
        } while (n > 0);
    }
}

