/*
 * Decompiled with CFR 0.152.
 */
package com.sun.star.lib.connections.websocket;

import com.sun.star.comp.loader.FactoryHelper;
import com.sun.star.connection.ConnectionSetupException;
import com.sun.star.connection.NoConnectException;
import com.sun.star.connection.XConnection;
import com.sun.star.connection.XConnector;
import com.sun.star.lang.IllegalArgumentException;
import com.sun.star.lang.XMultiServiceFactory;
import com.sun.star.lang.XSingleServiceFactory;
import com.sun.star.lib.connections.websocket.ConnectionDescriptor;
import com.sun.star.lib.connections.websocket.WebsocketConnection;
import com.sun.star.registry.XRegistryKey;
import java.io.IOException;
import java.net.URISyntaxException;

public final class websocketConnector
implements XConnector {
    public static final String __serviceName = "com.sun.star.connection.websocketConnector";
    private boolean connected = false;

    public static XSingleServiceFactory __getServiceFactory(String string, XMultiServiceFactory xMultiServiceFactory, XRegistryKey xRegistryKey) {
        return string.equals(websocketConnector.class.getName()) ? FactoryHelper.getServiceFactory(websocketConnector.class, __serviceName, xMultiServiceFactory, xRegistryKey) : null;
    }

    @Override
    public synchronized XConnection connect(String string) throws NoConnectException, ConnectionSetupException {
        ConnectionDescriptor connectionDescriptor;
        if (this.connected) {
            throw new ConnectionSetupException("Already connected to the socket");
        }
        try {
            connectionDescriptor = new ConnectionDescriptor(string);
        }
        catch (IllegalArgumentException illegalArgumentException) {
            throw new ConnectionSetupException(illegalArgumentException);
        }
        WebsocketConnection websocketConnection = null;
        try {
            websocketConnection = new WebsocketConnection(string, connectionDescriptor);
            this.connected = websocketConnection.isOpen();
        }
        catch (IOException iOException) {
            throw new ConnectionSetupException(iOException);
        }
        catch (URISyntaxException uRISyntaxException) {
            throw new ConnectionSetupException(uRISyntaxException);
        }
        catch (InterruptedException interruptedException) {
            throw new ConnectionSetupException(interruptedException);
        }
        if (websocketConnection == null || !this.connected) {
            throw new ConnectionSetupException("Could not connect to the server. Is it up?");
        }
        return websocketConnection;
    }
}

