/*
 * Decompiled with CFR 0.152.
 */
package sun.jvm.hotspot.classfile;

import java.util.Observable;
import java.util.Observer;
import sun.jvm.hotspot.debugger.Address;
import sun.jvm.hotspot.oops.Oop;
import sun.jvm.hotspot.runtime.VM;
import sun.jvm.hotspot.runtime.VMObject;
import sun.jvm.hotspot.types.AddressField;
import sun.jvm.hotspot.types.OopField;
import sun.jvm.hotspot.types.Type;
import sun.jvm.hotspot.types.TypeDataBase;
import sun.jvm.hotspot.types.WrongTypeException;

public class ClassLoaderData
extends VMObject {
    private static OopField classLoaderField;
    private static AddressField nextField;

    private static synchronized void initialize(TypeDataBase db) throws WrongTypeException {
        Type type = db.lookupType("ClassLoaderData");
        classLoaderField = type.getOopField("_class_loader");
        nextField = type.getAddressField("_next");
    }

    public ClassLoaderData(Address addr) {
        super(addr);
    }

    public static ClassLoaderData instantiateWrapperFor(Address addr) {
        if (addr == null) {
            return null;
        }
        return new ClassLoaderData(addr);
    }

    public Oop getClassLoader() {
        return VM.getVM().getObjectHeap().newOop(classLoaderField.getValue(this.getAddress()));
    }

    static {
        VM.registerVMInitializedObserver(new Observer(){

            @Override
            public void update(Observable o, Object data) {
                ClassLoaderData.initialize(VM.getVM().getTypeDataBase());
            }
        });
    }
}

