﻿/**
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * SPDX-License-Identifier: Apache-2.0.
 */

#pragma once
#include <aws/core/utils/memory/stl/AWSString.h>
#include <aws/storagegateway/StorageGateway_EXPORTS.h>

#include <utility>

namespace Aws {
template <typename RESULT_TYPE>
class AmazonWebServiceResult;

namespace Utils {
namespace Json {
class JsonValue;
}  // namespace Json
}  // namespace Utils
namespace StorageGateway {
namespace Model {
class AssignTapePoolResult {
 public:
  AWS_STORAGEGATEWAY_API AssignTapePoolResult() = default;
  AWS_STORAGEGATEWAY_API AssignTapePoolResult(const Aws::AmazonWebServiceResult<Aws::Utils::Json::JsonValue>& result);
  AWS_STORAGEGATEWAY_API AssignTapePoolResult& operator=(const Aws::AmazonWebServiceResult<Aws::Utils::Json::JsonValue>& result);

  ///@{
  /**
   * <p>The unique Amazon Resource Names (ARN) of the virtual tape that was added to
   * the tape pool.</p>
   */
  inline const Aws::String& GetTapeARN() const { return m_tapeARN; }
  template <typename TapeARNT = Aws::String>
  void SetTapeARN(TapeARNT&& value) {
    m_tapeARNHasBeenSet = true;
    m_tapeARN = std::forward<TapeARNT>(value);
  }
  template <typename TapeARNT = Aws::String>
  AssignTapePoolResult& WithTapeARN(TapeARNT&& value) {
    SetTapeARN(std::forward<TapeARNT>(value));
    return *this;
  }
  ///@}

  ///@{

  inline const Aws::String& GetRequestId() const { return m_requestId; }
  template <typename RequestIdT = Aws::String>
  void SetRequestId(RequestIdT&& value) {
    m_requestIdHasBeenSet = true;
    m_requestId = std::forward<RequestIdT>(value);
  }
  template <typename RequestIdT = Aws::String>
  AssignTapePoolResult& WithRequestId(RequestIdT&& value) {
    SetRequestId(std::forward<RequestIdT>(value));
    return *this;
  }
  ///@}
 private:
  Aws::String m_tapeARN;

  Aws::String m_requestId;
  bool m_tapeARNHasBeenSet = false;
  bool m_requestIdHasBeenSet = false;
};

}  // namespace Model
}  // namespace StorageGateway
}  // namespace Aws
