﻿/**
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * SPDX-License-Identifier: Apache-2.0.
 */

#pragma once
#include <aws/core/utils/memory/stl/AWSString.h>
#include <aws/securityhub/SecurityHub_EXPORTS.h>

namespace Aws {
namespace SecurityHub {
namespace Model {
enum class MalwareState { NOT_SET, OBSERVED, REMOVAL_FAILED, REMOVED };

namespace MalwareStateMapper {
AWS_SECURITYHUB_API MalwareState GetMalwareStateForName(const Aws::String& name);

AWS_SECURITYHUB_API Aws::String GetNameForMalwareState(MalwareState value);
}  // namespace MalwareStateMapper
}  // namespace Model
}  // namespace SecurityHub
}  // namespace Aws
