﻿/**
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * SPDX-License-Identifier: Apache-2.0.
 */

#pragma once
#include <aws/core/utils/memory/stl/AWSString.h>
#include <aws/route53profiles/Route53Profiles_EXPORTS.h>
#include <aws/route53profiles/model/ProfileResourceAssociation.h>

#include <utility>

namespace Aws {
template <typename RESULT_TYPE>
class AmazonWebServiceResult;

namespace Utils {
namespace Json {
class JsonValue;
}  // namespace Json
}  // namespace Utils
namespace Route53Profiles {
namespace Model {
class AssociateResourceToProfileResult {
 public:
  AWS_ROUTE53PROFILES_API AssociateResourceToProfileResult() = default;
  AWS_ROUTE53PROFILES_API AssociateResourceToProfileResult(const Aws::AmazonWebServiceResult<Aws::Utils::Json::JsonValue>& result);
  AWS_ROUTE53PROFILES_API AssociateResourceToProfileResult& operator=(
      const Aws::AmazonWebServiceResult<Aws::Utils::Json::JsonValue>& result);

  ///@{
  /**
   * <p> Infromation about the <code>AssociateResourceToProfile</code>, including a
   * status message. </p>
   */
  inline const ProfileResourceAssociation& GetProfileResourceAssociation() const { return m_profileResourceAssociation; }
  template <typename ProfileResourceAssociationT = ProfileResourceAssociation>
  void SetProfileResourceAssociation(ProfileResourceAssociationT&& value) {
    m_profileResourceAssociationHasBeenSet = true;
    m_profileResourceAssociation = std::forward<ProfileResourceAssociationT>(value);
  }
  template <typename ProfileResourceAssociationT = ProfileResourceAssociation>
  AssociateResourceToProfileResult& WithProfileResourceAssociation(ProfileResourceAssociationT&& value) {
    SetProfileResourceAssociation(std::forward<ProfileResourceAssociationT>(value));
    return *this;
  }
  ///@}

  ///@{

  inline const Aws::String& GetRequestId() const { return m_requestId; }
  template <typename RequestIdT = Aws::String>
  void SetRequestId(RequestIdT&& value) {
    m_requestIdHasBeenSet = true;
    m_requestId = std::forward<RequestIdT>(value);
  }
  template <typename RequestIdT = Aws::String>
  AssociateResourceToProfileResult& WithRequestId(RequestIdT&& value) {
    SetRequestId(std::forward<RequestIdT>(value));
    return *this;
  }
  ///@}
 private:
  ProfileResourceAssociation m_profileResourceAssociation;

  Aws::String m_requestId;
  bool m_profileResourceAssociationHasBeenSet = false;
  bool m_requestIdHasBeenSet = false;
};

}  // namespace Model
}  // namespace Route53Profiles
}  // namespace Aws
