﻿/**
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * SPDX-License-Identifier: Apache-2.0.
 */

#pragma once
#include <aws/core/utils/memory/stl/AWSString.h>
#include <aws/core/utils/memory/stl/AWSVector.h>
#include <aws/route53-recovery-readiness/Route53RecoveryReadinessRequest.h>
#include <aws/route53-recovery-readiness/Route53RecoveryReadiness_EXPORTS.h>

#include <utility>

namespace Aws {
namespace Route53RecoveryReadiness {
namespace Model {

/**
 */
class UpdateCellRequest : public Route53RecoveryReadinessRequest {
 public:
  AWS_ROUTE53RECOVERYREADINESS_API UpdateCellRequest() = default;

  // Service request name is the Operation name which will send this request out,
  // each operation should has unique request name, so that we can get operation's name from this request.
  // Note: this is not true for response, multiple operations may have the same response name,
  // so we can not get operation's name from response.
  inline virtual const char* GetServiceRequestName() const override { return "UpdateCell"; }

  AWS_ROUTE53RECOVERYREADINESS_API Aws::String SerializePayload() const override;

  ///@{
  /**
   * <p>The name of the cell.</p>
   */
  inline const Aws::String& GetCellName() const { return m_cellName; }
  inline bool CellNameHasBeenSet() const { return m_cellNameHasBeenSet; }
  template <typename CellNameT = Aws::String>
  void SetCellName(CellNameT&& value) {
    m_cellNameHasBeenSet = true;
    m_cellName = std::forward<CellNameT>(value);
  }
  template <typename CellNameT = Aws::String>
  UpdateCellRequest& WithCellName(CellNameT&& value) {
    SetCellName(std::forward<CellNameT>(value));
    return *this;
  }
  ///@}

  ///@{
  /**
   * <p>A list of cell Amazon Resource Names (ARNs), which completely replaces the
   * previous list.</p>
   */
  inline const Aws::Vector<Aws::String>& GetCells() const { return m_cells; }
  inline bool CellsHasBeenSet() const { return m_cellsHasBeenSet; }
  template <typename CellsT = Aws::Vector<Aws::String>>
  void SetCells(CellsT&& value) {
    m_cellsHasBeenSet = true;
    m_cells = std::forward<CellsT>(value);
  }
  template <typename CellsT = Aws::Vector<Aws::String>>
  UpdateCellRequest& WithCells(CellsT&& value) {
    SetCells(std::forward<CellsT>(value));
    return *this;
  }
  template <typename CellsT = Aws::String>
  UpdateCellRequest& AddCells(CellsT&& value) {
    m_cellsHasBeenSet = true;
    m_cells.emplace_back(std::forward<CellsT>(value));
    return *this;
  }
  ///@}
 private:
  Aws::String m_cellName;

  Aws::Vector<Aws::String> m_cells;
  bool m_cellNameHasBeenSet = false;
  bool m_cellsHasBeenSet = false;
};

}  // namespace Model
}  // namespace Route53RecoveryReadiness
}  // namespace Aws
