﻿/**
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * SPDX-License-Identifier: Apache-2.0.
 */

#pragma once
#include <aws/core/utils/memory/stl/AWSString.h>
#include <aws/core/utils/memory/stl/AWSVector.h>
#include <aws/redshift/Redshift_EXPORTS.h>
#include <aws/redshift/model/DataShare.h>
#include <aws/redshift/model/ResponseMetadata.h>

#include <utility>

namespace Aws {
template <typename RESULT_TYPE>
class AmazonWebServiceResult;

namespace Utils {
namespace Xml {
class XmlDocument;
}  // namespace Xml
}  // namespace Utils
namespace Redshift {
namespace Model {
class DescribeDataSharesResult {
 public:
  AWS_REDSHIFT_API DescribeDataSharesResult() = default;
  AWS_REDSHIFT_API DescribeDataSharesResult(const Aws::AmazonWebServiceResult<Aws::Utils::Xml::XmlDocument>& result);
  AWS_REDSHIFT_API DescribeDataSharesResult& operator=(const Aws::AmazonWebServiceResult<Aws::Utils::Xml::XmlDocument>& result);

  ///@{
  /**
   * <p>The results returned from describing datashares.</p>
   */
  inline const Aws::Vector<DataShare>& GetDataShares() const { return m_dataShares; }
  template <typename DataSharesT = Aws::Vector<DataShare>>
  void SetDataShares(DataSharesT&& value) {
    m_dataSharesHasBeenSet = true;
    m_dataShares = std::forward<DataSharesT>(value);
  }
  template <typename DataSharesT = Aws::Vector<DataShare>>
  DescribeDataSharesResult& WithDataShares(DataSharesT&& value) {
    SetDataShares(std::forward<DataSharesT>(value));
    return *this;
  }
  template <typename DataSharesT = DataShare>
  DescribeDataSharesResult& AddDataShares(DataSharesT&& value) {
    m_dataSharesHasBeenSet = true;
    m_dataShares.emplace_back(std::forward<DataSharesT>(value));
    return *this;
  }
  ///@}

  ///@{
  /**
   * <p>An optional parameter that specifies the starting point to return a set of
   * response records. When the results of a <a>DescribeDataShares</a> request exceed
   * the value specified in <code>MaxRecords</code>, Amazon Web Services returns a
   * value in the <code>Marker</code> field of the response. You can retrieve the
   * next set of response records by providing the returned marker value in the
   * <code>Marker</code> parameter and retrying the request. </p>
   */
  inline const Aws::String& GetMarker() const { return m_marker; }
  template <typename MarkerT = Aws::String>
  void SetMarker(MarkerT&& value) {
    m_markerHasBeenSet = true;
    m_marker = std::forward<MarkerT>(value);
  }
  template <typename MarkerT = Aws::String>
  DescribeDataSharesResult& WithMarker(MarkerT&& value) {
    SetMarker(std::forward<MarkerT>(value));
    return *this;
  }
  ///@}

  ///@{

  inline const ResponseMetadata& GetResponseMetadata() const { return m_responseMetadata; }
  template <typename ResponseMetadataT = ResponseMetadata>
  void SetResponseMetadata(ResponseMetadataT&& value) {
    m_responseMetadataHasBeenSet = true;
    m_responseMetadata = std::forward<ResponseMetadataT>(value);
  }
  template <typename ResponseMetadataT = ResponseMetadata>
  DescribeDataSharesResult& WithResponseMetadata(ResponseMetadataT&& value) {
    SetResponseMetadata(std::forward<ResponseMetadataT>(value));
    return *this;
  }
  ///@}
 private:
  Aws::Vector<DataShare> m_dataShares;

  Aws::String m_marker;

  ResponseMetadata m_responseMetadata;
  bool m_dataSharesHasBeenSet = false;
  bool m_markerHasBeenSet = false;
  bool m_responseMetadataHasBeenSet = false;
};

}  // namespace Model
}  // namespace Redshift
}  // namespace Aws
