﻿/**
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * SPDX-License-Identifier: Apache-2.0.
 */

#pragma once
#include <aws/core/utils/memory/stl/AWSString.h>
#include <aws/identitystore/IdentityStore_EXPORTS.h>

namespace Aws {
namespace IdentityStore {
namespace Model {
enum class ThrottlingExceptionReason { NOT_SET, KMS_THROTTLING };

namespace ThrottlingExceptionReasonMapper {
AWS_IDENTITYSTORE_API ThrottlingExceptionReason GetThrottlingExceptionReasonForName(const Aws::String& name);

AWS_IDENTITYSTORE_API Aws::String GetNameForThrottlingExceptionReason(ThrottlingExceptionReason value);
}  // namespace ThrottlingExceptionReasonMapper
}  // namespace Model
}  // namespace IdentityStore
}  // namespace Aws
