﻿/**
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * SPDX-License-Identifier: Apache-2.0.
 */

#pragma once
#include <aws/core/utils/memory/stl/AWSString.h>
#include <aws/eks/EKS_EXPORTS.h>
#include <aws/eks/model/AccessEntry.h>

#include <utility>

namespace Aws {
template <typename RESULT_TYPE>
class AmazonWebServiceResult;

namespace Utils {
namespace Json {
class JsonValue;
}  // namespace Json
}  // namespace Utils
namespace EKS {
namespace Model {
class CreateAccessEntryResult {
 public:
  AWS_EKS_API CreateAccessEntryResult() = default;
  AWS_EKS_API CreateAccessEntryResult(const Aws::AmazonWebServiceResult<Aws::Utils::Json::JsonValue>& result);
  AWS_EKS_API CreateAccessEntryResult& operator=(const Aws::AmazonWebServiceResult<Aws::Utils::Json::JsonValue>& result);

  ///@{

  inline const AccessEntry& GetAccessEntry() const { return m_accessEntry; }
  template <typename AccessEntryT = AccessEntry>
  void SetAccessEntry(AccessEntryT&& value) {
    m_accessEntryHasBeenSet = true;
    m_accessEntry = std::forward<AccessEntryT>(value);
  }
  template <typename AccessEntryT = AccessEntry>
  CreateAccessEntryResult& WithAccessEntry(AccessEntryT&& value) {
    SetAccessEntry(std::forward<AccessEntryT>(value));
    return *this;
  }
  ///@}

  ///@{

  inline const Aws::String& GetRequestId() const { return m_requestId; }
  template <typename RequestIdT = Aws::String>
  void SetRequestId(RequestIdT&& value) {
    m_requestIdHasBeenSet = true;
    m_requestId = std::forward<RequestIdT>(value);
  }
  template <typename RequestIdT = Aws::String>
  CreateAccessEntryResult& WithRequestId(RequestIdT&& value) {
    SetRequestId(std::forward<RequestIdT>(value));
    return *this;
  }
  ///@}
 private:
  AccessEntry m_accessEntry;

  Aws::String m_requestId;
  bool m_accessEntryHasBeenSet = false;
  bool m_requestIdHasBeenSet = false;
};

}  // namespace Model
}  // namespace EKS
}  // namespace Aws
