﻿/**
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * SPDX-License-Identifier: Apache-2.0.
 */

#pragma once
#include <aws/core/utils/memory/stl/AWSString.h>
#include <aws/dynamodb/DynamoDB_EXPORTS.h>
#include <aws/dynamodb/model/GlobalSecondaryIndexWarmThroughputDescription.h>
#include <aws/dynamodb/model/OnDemandThroughputOverride.h>
#include <aws/dynamodb/model/ProvisionedThroughputOverride.h>

#include <utility>

namespace Aws {
namespace Utils {
namespace Json {
class JsonValue;
class JsonView;
}  // namespace Json
}  // namespace Utils
namespace DynamoDB {
namespace Model {

/**
 * <p>Represents the properties of a replica global secondary index.</p><p><h3>See
 * Also:</h3>   <a
 * href="http://docs.aws.amazon.com/goto/WebAPI/dynamodb-2012-08-10/ReplicaGlobalSecondaryIndexDescription">AWS
 * API Reference</a></p>
 */
class ReplicaGlobalSecondaryIndexDescription {
 public:
  AWS_DYNAMODB_API ReplicaGlobalSecondaryIndexDescription() = default;
  AWS_DYNAMODB_API ReplicaGlobalSecondaryIndexDescription(Aws::Utils::Json::JsonView jsonValue);
  AWS_DYNAMODB_API ReplicaGlobalSecondaryIndexDescription& operator=(Aws::Utils::Json::JsonView jsonValue);
  AWS_DYNAMODB_API Aws::Utils::Json::JsonValue Jsonize() const;

  ///@{
  /**
   * <p>The name of the global secondary index.</p>
   */
  inline const Aws::String& GetIndexName() const { return m_indexName; }
  inline bool IndexNameHasBeenSet() const { return m_indexNameHasBeenSet; }
  template <typename IndexNameT = Aws::String>
  void SetIndexName(IndexNameT&& value) {
    m_indexNameHasBeenSet = true;
    m_indexName = std::forward<IndexNameT>(value);
  }
  template <typename IndexNameT = Aws::String>
  ReplicaGlobalSecondaryIndexDescription& WithIndexName(IndexNameT&& value) {
    SetIndexName(std::forward<IndexNameT>(value));
    return *this;
  }
  ///@}

  ///@{
  /**
   * <p>If not described, uses the source table GSI's read capacity settings.</p>
   */
  inline const ProvisionedThroughputOverride& GetProvisionedThroughputOverride() const { return m_provisionedThroughputOverride; }
  inline bool ProvisionedThroughputOverrideHasBeenSet() const { return m_provisionedThroughputOverrideHasBeenSet; }
  template <typename ProvisionedThroughputOverrideT = ProvisionedThroughputOverride>
  void SetProvisionedThroughputOverride(ProvisionedThroughputOverrideT&& value) {
    m_provisionedThroughputOverrideHasBeenSet = true;
    m_provisionedThroughputOverride = std::forward<ProvisionedThroughputOverrideT>(value);
  }
  template <typename ProvisionedThroughputOverrideT = ProvisionedThroughputOverride>
  ReplicaGlobalSecondaryIndexDescription& WithProvisionedThroughputOverride(ProvisionedThroughputOverrideT&& value) {
    SetProvisionedThroughputOverride(std::forward<ProvisionedThroughputOverrideT>(value));
    return *this;
  }
  ///@}

  ///@{
  /**
   * <p>Overrides the maximum on-demand throughput for the specified global secondary
   * index in the specified replica table.</p>
   */
  inline const OnDemandThroughputOverride& GetOnDemandThroughputOverride() const { return m_onDemandThroughputOverride; }
  inline bool OnDemandThroughputOverrideHasBeenSet() const { return m_onDemandThroughputOverrideHasBeenSet; }
  template <typename OnDemandThroughputOverrideT = OnDemandThroughputOverride>
  void SetOnDemandThroughputOverride(OnDemandThroughputOverrideT&& value) {
    m_onDemandThroughputOverrideHasBeenSet = true;
    m_onDemandThroughputOverride = std::forward<OnDemandThroughputOverrideT>(value);
  }
  template <typename OnDemandThroughputOverrideT = OnDemandThroughputOverride>
  ReplicaGlobalSecondaryIndexDescription& WithOnDemandThroughputOverride(OnDemandThroughputOverrideT&& value) {
    SetOnDemandThroughputOverride(std::forward<OnDemandThroughputOverrideT>(value));
    return *this;
  }
  ///@}

  ///@{
  /**
   * <p>Represents the warm throughput of the global secondary index for this
   * replica.</p>
   */
  inline const GlobalSecondaryIndexWarmThroughputDescription& GetWarmThroughput() const { return m_warmThroughput; }
  inline bool WarmThroughputHasBeenSet() const { return m_warmThroughputHasBeenSet; }
  template <typename WarmThroughputT = GlobalSecondaryIndexWarmThroughputDescription>
  void SetWarmThroughput(WarmThroughputT&& value) {
    m_warmThroughputHasBeenSet = true;
    m_warmThroughput = std::forward<WarmThroughputT>(value);
  }
  template <typename WarmThroughputT = GlobalSecondaryIndexWarmThroughputDescription>
  ReplicaGlobalSecondaryIndexDescription& WithWarmThroughput(WarmThroughputT&& value) {
    SetWarmThroughput(std::forward<WarmThroughputT>(value));
    return *this;
  }
  ///@}
 private:
  Aws::String m_indexName;

  ProvisionedThroughputOverride m_provisionedThroughputOverride;

  OnDemandThroughputOverride m_onDemandThroughputOverride;

  GlobalSecondaryIndexWarmThroughputDescription m_warmThroughput;
  bool m_indexNameHasBeenSet = false;
  bool m_provisionedThroughputOverrideHasBeenSet = false;
  bool m_onDemandThroughputOverrideHasBeenSet = false;
  bool m_warmThroughputHasBeenSet = false;
};

}  // namespace Model
}  // namespace DynamoDB
}  // namespace Aws
