﻿/**
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * SPDX-License-Identifier: Apache-2.0.
 */

#pragma once
#include <aws/connect/ConnectRequest.h>
#include <aws/connect/Connect_EXPORTS.h>
#include <aws/core/utils/memory/stl/AWSString.h>

#include <utility>

namespace Aws {
namespace Connect {
namespace Model {

/**
 */
class DescribeAgentStatusRequest : public ConnectRequest {
 public:
  AWS_CONNECT_API DescribeAgentStatusRequest() = default;

  // Service request name is the Operation name which will send this request out,
  // each operation should has unique request name, so that we can get operation's name from this request.
  // Note: this is not true for response, multiple operations may have the same response name,
  // so we can not get operation's name from response.
  inline virtual const char* GetServiceRequestName() const override { return "DescribeAgentStatus"; }

  AWS_CONNECT_API Aws::String SerializePayload() const override;

  ///@{
  /**
   * <p>The identifier of the Amazon Connect instance. You can <a
   * href="https://docs.aws.amazon.com/connect/latest/adminguide/find-instance-arn.html">find
   * the instance ID</a> in the Amazon Resource Name (ARN) of the instance.</p>
   */
  inline const Aws::String& GetInstanceId() const { return m_instanceId; }
  inline bool InstanceIdHasBeenSet() const { return m_instanceIdHasBeenSet; }
  template <typename InstanceIdT = Aws::String>
  void SetInstanceId(InstanceIdT&& value) {
    m_instanceIdHasBeenSet = true;
    m_instanceId = std::forward<InstanceIdT>(value);
  }
  template <typename InstanceIdT = Aws::String>
  DescribeAgentStatusRequest& WithInstanceId(InstanceIdT&& value) {
    SetInstanceId(std::forward<InstanceIdT>(value));
    return *this;
  }
  ///@}

  ///@{
  /**
   * <p>The identifier for the agent status.</p>
   */
  inline const Aws::String& GetAgentStatusId() const { return m_agentStatusId; }
  inline bool AgentStatusIdHasBeenSet() const { return m_agentStatusIdHasBeenSet; }
  template <typename AgentStatusIdT = Aws::String>
  void SetAgentStatusId(AgentStatusIdT&& value) {
    m_agentStatusIdHasBeenSet = true;
    m_agentStatusId = std::forward<AgentStatusIdT>(value);
  }
  template <typename AgentStatusIdT = Aws::String>
  DescribeAgentStatusRequest& WithAgentStatusId(AgentStatusIdT&& value) {
    SetAgentStatusId(std::forward<AgentStatusIdT>(value));
    return *this;
  }
  ///@}
 private:
  Aws::String m_instanceId;

  Aws::String m_agentStatusId;
  bool m_instanceIdHasBeenSet = false;
  bool m_agentStatusIdHasBeenSet = false;
};

}  // namespace Model
}  // namespace Connect
}  // namespace Aws
