﻿/**
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * SPDX-License-Identifier: Apache-2.0.
 */

#pragma once
#include <aws/config/ConfigServiceRequest.h>
#include <aws/config/ConfigService_EXPORTS.h>
#include <aws/config/model/ComplianceType.h>
#include <aws/core/utils/memory/stl/AWSString.h>
#include <aws/core/utils/memory/stl/AWSVector.h>

#include <utility>

namespace Aws {
namespace ConfigService {
namespace Model {

/**
 * <p/><p><h3>See Also:</h3>   <a
 * href="http://docs.aws.amazon.com/goto/WebAPI/config-2014-11-12/DescribeComplianceByResourceRequest">AWS
 * API Reference</a></p>
 */
class DescribeComplianceByResourceRequest : public ConfigServiceRequest {
 public:
  AWS_CONFIGSERVICE_API DescribeComplianceByResourceRequest() = default;

  // Service request name is the Operation name which will send this request out,
  // each operation should has unique request name, so that we can get operation's name from this request.
  // Note: this is not true for response, multiple operations may have the same response name,
  // so we can not get operation's name from response.
  inline virtual const char* GetServiceRequestName() const override { return "DescribeComplianceByResource"; }

  AWS_CONFIGSERVICE_API Aws::String SerializePayload() const override;

  AWS_CONFIGSERVICE_API Aws::Http::HeaderValueCollection GetRequestSpecificHeaders() const override;

  ///@{
  /**
   * <p>The types of Amazon Web Services resources for which you want compliance
   * information (for example, <code>AWS::EC2::Instance</code>). For this operation,
   * you can specify that the resource type is an Amazon Web Services account by
   * specifying <code>AWS::::Account</code>.</p>
   */
  inline const Aws::String& GetResourceType() const { return m_resourceType; }
  inline bool ResourceTypeHasBeenSet() const { return m_resourceTypeHasBeenSet; }
  template <typename ResourceTypeT = Aws::String>
  void SetResourceType(ResourceTypeT&& value) {
    m_resourceTypeHasBeenSet = true;
    m_resourceType = std::forward<ResourceTypeT>(value);
  }
  template <typename ResourceTypeT = Aws::String>
  DescribeComplianceByResourceRequest& WithResourceType(ResourceTypeT&& value) {
    SetResourceType(std::forward<ResourceTypeT>(value));
    return *this;
  }
  ///@}

  ///@{
  /**
   * <p>The ID of the Amazon Web Services resource for which you want compliance
   * information. You can specify only one resource ID. If you specify a resource ID,
   * you must also specify a type for <code>ResourceType</code>.</p>
   */
  inline const Aws::String& GetResourceId() const { return m_resourceId; }
  inline bool ResourceIdHasBeenSet() const { return m_resourceIdHasBeenSet; }
  template <typename ResourceIdT = Aws::String>
  void SetResourceId(ResourceIdT&& value) {
    m_resourceIdHasBeenSet = true;
    m_resourceId = std::forward<ResourceIdT>(value);
  }
  template <typename ResourceIdT = Aws::String>
  DescribeComplianceByResourceRequest& WithResourceId(ResourceIdT&& value) {
    SetResourceId(std::forward<ResourceIdT>(value));
    return *this;
  }
  ///@}

  ///@{
  /**
   * <p>Filters the results by compliance.</p>
   */
  inline const Aws::Vector<ComplianceType>& GetComplianceTypes() const { return m_complianceTypes; }
  inline bool ComplianceTypesHasBeenSet() const { return m_complianceTypesHasBeenSet; }
  template <typename ComplianceTypesT = Aws::Vector<ComplianceType>>
  void SetComplianceTypes(ComplianceTypesT&& value) {
    m_complianceTypesHasBeenSet = true;
    m_complianceTypes = std::forward<ComplianceTypesT>(value);
  }
  template <typename ComplianceTypesT = Aws::Vector<ComplianceType>>
  DescribeComplianceByResourceRequest& WithComplianceTypes(ComplianceTypesT&& value) {
    SetComplianceTypes(std::forward<ComplianceTypesT>(value));
    return *this;
  }
  inline DescribeComplianceByResourceRequest& AddComplianceTypes(ComplianceType value) {
    m_complianceTypesHasBeenSet = true;
    m_complianceTypes.push_back(value);
    return *this;
  }
  ///@}

  ///@{
  /**
   * <p>The maximum number of evaluation results returned on each page. The default
   * is 10. You cannot specify a number greater than 100. If you specify 0, Config
   * uses the default.</p>
   */
  inline int GetLimit() const { return m_limit; }
  inline bool LimitHasBeenSet() const { return m_limitHasBeenSet; }
  inline void SetLimit(int value) {
    m_limitHasBeenSet = true;
    m_limit = value;
  }
  inline DescribeComplianceByResourceRequest& WithLimit(int value) {
    SetLimit(value);
    return *this;
  }
  ///@}

  ///@{
  /**
   * <p>The <code>nextToken</code> string returned on a previous page that you use to
   * get the next page of results in a paginated response.</p>
   */
  inline const Aws::String& GetNextToken() const { return m_nextToken; }
  inline bool NextTokenHasBeenSet() const { return m_nextTokenHasBeenSet; }
  template <typename NextTokenT = Aws::String>
  void SetNextToken(NextTokenT&& value) {
    m_nextTokenHasBeenSet = true;
    m_nextToken = std::forward<NextTokenT>(value);
  }
  template <typename NextTokenT = Aws::String>
  DescribeComplianceByResourceRequest& WithNextToken(NextTokenT&& value) {
    SetNextToken(std::forward<NextTokenT>(value));
    return *this;
  }
  ///@}
 private:
  Aws::String m_resourceType;

  Aws::String m_resourceId;

  Aws::Vector<ComplianceType> m_complianceTypes;

  int m_limit{0};

  Aws::String m_nextToken;
  bool m_resourceTypeHasBeenSet = false;
  bool m_resourceIdHasBeenSet = false;
  bool m_complianceTypesHasBeenSet = false;
  bool m_limitHasBeenSet = false;
  bool m_nextTokenHasBeenSet = false;
};

}  // namespace Model
}  // namespace ConfigService
}  // namespace Aws
