﻿/**
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * SPDX-License-Identifier: Apache-2.0.
 */

#pragma once
#include <aws/bcm-dashboards/BCMDashboards_EXPORTS.h>
#include <aws/bcm-dashboards/model/GroupDefinitionType.h>
#include <aws/core/utils/memory/stl/AWSString.h>

#include <utility>

namespace Aws {
namespace Utils {
namespace Json {
class JsonValue;
class JsonView;
}  // namespace Json
}  // namespace Utils
namespace BCMDashboards {
namespace Model {

/**
 * <p>Specifies how to group cost and usage data.</p><p><h3>See Also:</h3>   <a
 * href="http://docs.aws.amazon.com/goto/WebAPI/bcm-dashboards-2025-08-18/GroupDefinition">AWS
 * API Reference</a></p>
 */
class GroupDefinition {
 public:
  AWS_BCMDASHBOARDS_API GroupDefinition() = default;
  AWS_BCMDASHBOARDS_API GroupDefinition(Aws::Utils::Json::JsonView jsonValue);
  AWS_BCMDASHBOARDS_API GroupDefinition& operator=(Aws::Utils::Json::JsonView jsonValue);
  AWS_BCMDASHBOARDS_API Aws::Utils::Json::JsonValue Jsonize() const;

  ///@{
  /**
   * <p>The key to use for grouping cost and usage data.</p>
   */
  inline const Aws::String& GetKey() const { return m_key; }
  inline bool KeyHasBeenSet() const { return m_keyHasBeenSet; }
  template <typename KeyT = Aws::String>
  void SetKey(KeyT&& value) {
    m_keyHasBeenSet = true;
    m_key = std::forward<KeyT>(value);
  }
  template <typename KeyT = Aws::String>
  GroupDefinition& WithKey(KeyT&& value) {
    SetKey(std::forward<KeyT>(value));
    return *this;
  }
  ///@}

  ///@{
  /**
   * <p>The type of grouping to apply.</p>
   */
  inline GroupDefinitionType GetType() const { return m_type; }
  inline bool TypeHasBeenSet() const { return m_typeHasBeenSet; }
  inline void SetType(GroupDefinitionType value) {
    m_typeHasBeenSet = true;
    m_type = value;
  }
  inline GroupDefinition& WithType(GroupDefinitionType value) {
    SetType(value);
    return *this;
  }
  ///@}
 private:
  Aws::String m_key;

  GroupDefinitionType m_type{GroupDefinitionType::NOT_SET};
  bool m_keyHasBeenSet = false;
  bool m_typeHasBeenSet = false;
};

}  // namespace Model
}  // namespace BCMDashboards
}  // namespace Aws
